<?php

include_once 'conexao.php';
 
class ModeloMateria
{     
	static public function mdlAddMateriaTema($dados){
  
		$stmt = Conexao::conectar()->prepare("INSERT INTO materia
						(textoMateria, idProfessor, dataCadastro,idVaga,ordem,idTema, descricaoMateria, audio, video) VALUES (:textoMateria, :idProfessor, :dataCadastro,:idVaga,:ordem,:idTema,:descricaoMateria, :audio, :video)");
		$stmt->bindParam(":idVaga", $dados["idVaga"], PDO::PARAM_STR);
		$stmt->bindParam(":descricaoMateria", $dados["descricaoMateria"], PDO::PARAM_STR);
		$stmt->bindParam(":idTema", $dados["idTema"], PDO::PARAM_STR);
		$stmt->bindParam(":audio", $dados["audio"], PDO::PARAM_STR);
		$stmt->bindParam(":video", $dados["video"], PDO::PARAM_STR);
		$stmt->bindParam(":textoMateria", $dados["textoMateria"], PDO::PARAM_STR);
		$stmt->bindParam(":dataCadastro", $dados["dataCadastro"], PDO::PARAM_STR);
		$stmt->bindParam(":ordem", $dados["ordem"], PDO::PARAM_STR);
		$stmt->bindParam(":idProfessor", $dados["idUsuario"], PDO::PARAM_STR);
 
		if($stmt->execute()){
			return "ok";
		}else{
			return "error";
		}

	}
 
	static public function mdlMostrarTodasAsMateriaTemasDaVagaPoridVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM materia where idVaga = :idVaga order by idMateriaParte");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}
	
	static public function mdlMostrarTodasAsMateriaTemasDaVagaPoridVagaEDescricaoMateria($idVaga,$descricaoMateriaTopico) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM materia where idVaga = :idVaga and descricaoMateria = :descricaoMateria order by idMateriaParte");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":descricaoMateria", $descricaoMateriaTopico, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}  

	static public function mdlMostrarEOrdenarmateriatemasPorNumeroDeOrdemTodasAsmateriatemasDaVagaPoridVaga($idVaga) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM materia where idVaga = :idVaga order by idMateriaParte");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	}
  
	static public function mdlVerificarMateriaPoridVagaIdTemaEMateria($idVaga, $idTema, $descricaoMateria) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM materia where idVaga = :idVaga and idTema = :i and descricaoMateria = :d order by idMateriaParte");
			$stmt->bindParam(":idVaga", $idVaga, PDO::PARAM_STR);
			$stmt->bindParam(":i", $idTema, PDO::PARAM_STR);
			$stmt->bindParam(":d", $descricaoMateria, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;
 
	} 

	static public function mdlMostrarMateriaPorIdTema($idTema) {

		$resultado = array(); 

			$stmt = Conexao::conectar()->prepare("SELECT * FROM materia where idTema = :i");
			$stmt->bindParam(":i", $idTema, PDO::PARAM_STR);
			$stmt ->execute();

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlMostrarMateriaPorIdMateria($idMateriaParte) {

		$resultado = array(); 

		$stmt = Conexao::conectar()->prepare("SELECT * FROM materia where idMateriaParte = :idMateriaParte");
		$stmt->bindParam(":idMateriaParte", $idMateriaParte, PDO::PARAM_STR);
		$stmt ->execute();

		$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
		return $resultado;

	}

	

	static public function mdlAddImagemPorIdMateriaEIdTemaEIdVaga($imagem, $idMateriaParte, $idTema, $idVaga) {

		$resultado = array();

			$stmt = Conexao::conectar()->query("UPDATE materia SET 	imagem = '$imagem' where idMateriaParte  = '$idMateriaParte' AND idTema = '$idTema' and idVaga = '$idVaga'");
			if($stmt->execute()){
				return "ok";
			}else{
				return "error";
			}

			$resultado = $stmt ->fetchAll(PDO::FETCH_ASSOC);
			return $resultado;

	}

	static public function mdlAddVideoPorIdMateriaEIdTemaEIdVaga($video, $idMateriaParte, $idTema, $idVaga) {

			$stmt = Conexao::conectar()->query("UPDATE materia SET 	video = '$video' where idMateriaParte  = '$idMateriaParte' AND idTema = '$idTema' and idVaga = '$idVaga'");
			if($stmt->execute()){
				return "ok";
			}else{
				return "error";
			}

	}

	static public function mdlAddAudioPorIdMateriaEIdTemaEIdVaga($audio, $idMateriaParte, $idTema, $idVaga) {


			$stmt = Conexao::conectar()->query("UPDATE materia SET audio = '$audio' where idMateriaParte  = '$idMateriaParte' AND idTema = '$idTema' and idVaga = '$idVaga'");
			
			if($stmt->execute()){
				return "ok";
			}else{
				return "error";
			}

	}

	static public function mdlEditarMateriaaPorIdMateriaParte($idMateriaParte, $descricaoMateria, $textoMateria){
 
		$stmt = Conexao::conectar()->prepare("UPDATE materia SET  descricaoMateria = :descricaoMateria, textoMateria = :textoMateria   where idMateriaParte = :idMateriaParte ");
		$stmt->bindParam(":idMateriaParte", $idMateriaParte, PDO::PARAM_STR);
		$stmt->bindParam(":descricaoMateria", $descricaoMateria, PDO::PARAM_STR);
		$stmt->bindParam(":textoMateria", $textoMateria, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

	static public function mdlEliminarMateriaPorIdMateriaParte($id){
 
		$stmt = Conexao::conectar()->prepare("DELETE FROM materia where idMateriaParte = :id ");
		$stmt->bindParam(":id", $id, PDO::PARAM_STR);
		if($stmt->execute()){
			return "ok"; 
		}else{
			return "error";
		}

	}

}



?>